<?php
// Démarrage de la session
session_start();

// Inclusions des fichiers nécessaires
include("admin/config/bdd_config.inc");
include("admin/inc/bdd_connect.php");
include("inc/utils.php");
include("func/produit_inc.php");
include("func/panier_inc.php");

// Vérification de la présence du paramètre 'commande' dans l'URL
if(isset($_GET['commande']) && is_numeric($_GET['commande'])) {
    // Préparation de la requête pour éviter les injections SQL
    $statut = "Payee";
    $idcde = intval($_GET['commande']); // Conversion en entier pour s'assurer de la sécurité
    $sql = "UPDATE commande SET statut = ? WHERE idcde = ?";
    
    // Préparation et exécution de la requête
    $stmt = $bdd->prepare($sql);
    $stmt->execute(array($statut, $idcde));

    // Nettoyage du panier dans la session
    $_SESSION['PANIER'] = "";

    // Redirection vers la page de commande avec confirmation
    header("Location: commande.php?payee&commande=" . $idcde);
    exit;
} else {
    // Redirection en cas d'erreur ou si le paramètre 'commande' est manquant ou invalide
    header("Location: erreur.php");
    exit;
}
?>
