<?php
// Démarrage de la session et inclusion des fichiers nécessaires
session_start();
include("admin/config/bdd_config.inc");
include("admin/inc/bdd_connect.php");
include("inc/utils.php");
include("func/categorie_inc.php");
include("func/produit_inc.php");
include("func/panier_inc.php");
include("inc/top.php");
include("inc/bottom.php");

// Traitement et sécurisation de l'entrée
$catId = isset($_GET['cat']) ? intval($_GET['cat']) : 0; // Sécurisation et validation de l'entrée

// Obtention du titre de la catégorie et des produits associés
$categorieTitre = getCategorieTitre($bdd, $catId);
$produitsDeLaCategorie = getProductFromCategorie($bdd, $catId);
?>

<div class="well well-small">
    <h3><?php echo htmlspecialchars($categorieTitre); ?></h3>
    <hr class="soften"/>
    <?php echo $produitsDeLaCategorie; // Assurez-vous que cette fonction échappe correctement le HTML pour éviter les XSS ?>
</div>